#!/bin/bash

clear;

echo 'DVF'
python3 eval_video_interpolation.py \
	--gt-dir ucf101_interp_ours \
	--motion-mask-dir MotionMasks/ \
	--res-dir ucf101_interp_ours/ \
	--res-suffix _ours.png \
	--buggy-motion-mask

echo 'SepConv'
python3 eval_video_interpolation.py \
	--gt-dir ucf101_interp_ours \
	--motion-mask-dir MotionMasks/ \
	--res-dir ucf101_sepconv/ \
	--res-suffix _gt.png \
	--buggy-motion-mask

echo 'SuperSloMo_Adobe240fps'
python3 eval_video_interpolation.py \
	--gt-dir ucf101_interp_ours \
	--motion-mask-dir MotionMasks/ \
	--res-dir ucf101_superslomo_adobe240fps/ \
	--res-suffix _interp_001.png \
	--buggy-motion-mask

echo 'SuperSloMo'
python3 eval_video_interpolation.py \
	--gt-dir ucf101_interp_ours \
	--motion-mask-dir MotionMasks/ \
	--res-dir ucf101_superslomo/ \
	--res-suffix _superslomo.png \
	--buggy-motion-mask

# What I got were
# DVF
# 100%|█████████████████████████████████████████████████████████████████████████████████████████████████████████████████████████████████████████████████████████████████████| 379/379 [00:23<00:00, 16.14it/s]
# PSNR: 32.47, SSIM: 0.930, IE: 8.27
# SepConv
# 100%|█████████████████████████████████████████████████████████████████████████████████████████████████████████████████████████████████████████████████████████████████████| 379/379 [00:29<00:00, 12.74it/s]
# PSNR: 33.04, SSIM: 0.935, IE: 8.03
# SuperSloMo_Adobe240fps
# 100%|█████████████████████████████████████████████████████████████████████████████████████████████████████████████████████████████████████████████████████████████████████| 379/379 [00:30<00:00, 12.56it/s]
# PSNR: 32.81, SSIM: 0.936, IE: 8.05
# SuperSloMo
# 100%|█████████████████████████████████████████████████████████████████████████████████████████████████████████████████████████████████████████████████████████████████████| 379/379 [00:26<00:00, 14.44it/s]
# PSNR: 33.14, SSIM: 0.938, IE: 7.80
