#!/bin/bash

clear;

echo 'DVF'
python3 eval_video_interpolation.py \
	--gt-dir ucf101_interp_ours \
	--motion-mask-dir motion_masks_ucf101_interp/ \
	--res-dir ucf101_interp_ours/ \
	--res-suffix _ours.png  \
	--mask-out

echo 'SepConv'
python3 eval_video_interpolation.py \
	--gt-dir ucf101_interp_ours \
	--motion-mask-dir motion_masks_ucf101_interp/ \
	--res-dir ucf101_sepconv/ \
	--res-suffix _gt.png  \
	--mask-out

echo 'SuperSloMo_Adobe240fps'
python3 eval_video_interpolation.py \
	--gt-dir ucf101_interp_ours \
	--motion-mask-dir motion_masks_ucf101_interp/ \
	--res-dir ucf101_superslomo_adobe240fps/ \
	--res-suffix _interp_001.png  \
	--mask-out

echo 'SuperSloMo'
python3 eval_video_interpolation.py \
	--gt-dir ucf101_interp_ours \
	--motion-mask-dir motion_masks_ucf101_interp/ \
	--res-dir ucf101_superslomo/ \
	--res-suffix _superslomo.png \
	--mask-out

# What I got were
# DVF
# 100%|█████████████████████████████████████████████████████████████████████████████████████████████████████████████████████████████████████████████████████████████████████| 379/379 [00:21<00:00, 17.40it/s]
# PSNR: 36.93, SSIM: 0.962, IE: 3.73
# SepConv
# 100%|█████████████████████████████████████████████████████████████████████████████████████████████████████████████████████████████████████████████████████████████████████| 379/379 [00:21<00:00, 17.39it/s]
# PSNR: 37.44, SSIM: 0.963, IE: 3.78
# SuperSloMo_Adobe240fps
# 100%|█████████████████████████████████████████████████████████████████████████████████████████████████████████████████████████████████████████████████████████████████████| 379/379 [00:22<00:00, 16.75it/s]
# PSNR: 36.84, SSIM: 0.963, IE: 4.01
# SuperSloMo
# 100%|█████████████████████████████████████████████████████████████████████████████████████████████████████████████████████████████████████████████████████████████████████| 379/379 [00:21<00:00, 17.26it/s]
# PSNR: 37.43, SSIM: 0.965, IE: 3.79
