image_name = './data/1_45_45397.png';
image = imread( image_name );

addpath(genpath('.'));

% load classifiers
% classifier for multiple segmentations
load('./trained_classifiers/same_label_classifier_200_20.mat');
classifiers.same_label_classifier = same_label_classifier;
classifiers.ecal = ecal;

% classifier for saliency regression
load( './trained_classifiers/segment_saliency_regressor_48_segmentations_MSRA_200_15_compressed_rf.mat' );
classifiers.segment_saliency_regressor = segment_saliency_regressor;

% parameters including the number of segmentations and saliency fusion
% weight
para = makeDefaultParameters();

% textons are obtained from the gPb edge detector
% if textons are not provided, they will be computed automatically
gpb_file_name = [image_name(1:end-4), '.mat'];
gpb_data = load( gpb_file_name, 'textons' );

t = tic;
smap = Saliency_DRFI( image, classifiers, para, gpb_data.textons );
% smap = Saliency_DRFI( image, classifiers, para, [] );
time_cost = toc(t);
fprintf( 'time cost for saliency computation using DRFI approach: %.3f\n', time_cost );