function imsegs = processSuperpixelImage(fn)
% imsegs = processSuperpixelImage(fn)
% Creates the imsegs structure from a segmentation image
%
% INPUT: 
% fn - filenames of segmentation images. Use '/' (not '\') to separate directories. 
% Segments are denoted by different RGB colors.  
%
% OUTPUT:
% imsegs - image segmentation data 
%
% Copyright(C) Derek Hoiem, Carnegie Mellon University, 2006
% Current Version: 1.0  04/24/2006
          
% if isstr(fn)
%     fn = {fn};
% end

fn = {fn};

imsegs(length(fn)) = struct('imname', '', 'imsize', [0 0]);
for f = 1:length(fn)        
    im = double(fn{f});
    
    imsegs(f).imname = 'empty';
    imsegs(f).imsize = size(im);
    imsegs(f).imsize = imsegs(f).imsize(1:2);
    im = im(:, :, 1) + im(:, :, 2)*256 + im(:, :, 3)*256^2;
    [gid, gn] = grp2idx(im(:));
    imsegs(f).segimage = uint16(reshape(gid, imsegs(f).imsize));
    imsegs(f).nseg = length(gn);
end
imsegs = APPgetSpStats(imsegs);