function saliencyMap = computeOneScaleSmap_fast(regionHist, imsegs)
    segimage = imsegs.segimage;
    [h w c] = size(segimage);
    
    [x y] = meshgrid(-w/2+1:w/2, -h/2+1:h/2); 
    x = x.^2;
    y = y.^2;
    
    adjmat = imsegs.adjmat;
    
    num_region = max(imsegs.segimage(:));
    
    saliencyMap = zeros(h, w);
    
    spstats = regionprops(segimage, 'PixelIdxList');
    area = zeros(num_region, 1);
    spatial_prior = zeros(num_region, 1);
    c = 3;
    for ix = 1 : num_region
        area(ix) = length(spstats(ix).PixelIdxList);
        adjmat(ix, ix) = 0;
        
        temp_x_dist = mean(x(spstats(ix).PixelIdxList));
        temp_y_dist = mean(y(spstats(ix).PixelIdxList));
        spatial_prior(ix) = exp(-c^2*temp_x_dist/w^2 - c^2*temp_y_dist/h^2);
    end
    
    area_weight = repmat(area', [num_region, 1]) .* double(adjmat);
    
    area_weight = area_weight ./ repmat(sum(area_weight, 2), [1, num_region]);
    
    node_weight = area / h /w / 0.52;
    node_weight = 1 ./ (1 + (node_weight).^11);
    
    region_dist = zeros(num_region, num_region);
    
    ind = find(adjmat);
    for ix = 1 : length(ind)
        [x y] = ind2sub([num_region, num_region], ind(ix));
        region_dist(x, y) = histDist(regionHist(x,:), regionHist(y,:));
    end
    
    temp_saliency = -log(1 - region_dist) .* area_weight;
    saliency = spatial_prior .* sum(temp_saliency, 2) .* node_weight;
    
    for ix = 1 : num_region
        saliencyMap(spstats(ix).PixelIdxList) = repmat(saliency(ix), size(spstats(ix).PixelIdxList));
    end
    
    %saliencyMap = saliencyMap .* spatialPrior;