function smap = CBSaliency( image, seg_paras, bins, th, epsilon )
    % parameters used for multiple segmentations
    if ~exist('seg_paras', 'var')
        seg_paras = [0.3	350	1200;
                     0.4	350	1200;
                     0.5	350	1200;
                     0.6	350	1200;
                     0.7	350	1200;
                     0.8	350	1200;
                     0.9	350	1200;
                     1.0	350	1200];
    end
    
    % bin of color histogram
    if ~exist('bins', 'var')
        bins = [8 16 16 4];       % CIE L*, a*, b*, and hue respectively
    end
    
    % threshold for merging adjacent superpixels
    if ~exist('th', 'var')
        th = 0.2;
    end
    
    % the parameter used in Eqn.(2)
    if ~exist('epsilon', 'var')
        epsilon = 0.1;
    end

    % first resize the image to a fixed size. The parameters may be more
    % suitable on this scale
    h = size(image, 1);
    w = size(image, 2);
    r = 400 / max(w, h);
    image = imresize(image, r);
    image = im2double(image);
    
    % compute quantize the image for color histogram generation
    Q = computeQuantMatrix(image, bins);
    
    smap = zeros(size(image,1), size(image,2));
    t1 = zeros(size(smap));
    t2 = zeros(size(smap));
    
    %addpath('./segment');
             
    parfor ix = 1 : size(seg_paras,1)
        % segment the image according to give parameters
        imsegs = im2superpixels(image, seg_paras(ix,:));

        % for each region, compute the color histogram
        rh = computeRegionHist(Q, bins, imsegs.segimage);

        % to achieve better performance, merge adjacent regions if their
        % color distance is less then the given threshold
        imsegs2 = mergeAdjacentRegions_fast(rh, imsegs, th);
        
        num_region = max(imsegs2.segimage(:));
        fprintf('\t*** after merging, #num_region: %d\n', num_region);
       
        % compute the region color histogram for merged regions
        rh2 = computeRegionHist(Q, bins, imsegs2.segimage);

        % compute the color center for each region
        color_center = computeColorCenter(image, imsegs2.segimage);

        % for each pixel, compute its color distance to the color center of
        % the region which contains the pixel
        temp_color_weight = computeColorWeight(image, imsegs2.segimage, color_center, epsilon);

        % compute one superpixel-scale saliency map based on context
        % analysis
        temp_smap = computeOneScaleSmap_fast(rh2, imsegs2);
        
%         smaps{ix} = temp_smap;      
%         color_weight{ix} = temp_color_weight;        
        
        t1 = t1 + temp_smap .* temp_color_weight;
        t2 = t2 + temp_color_weight;
    end
    
    % propogate the saliency value from region to pixel, which is
    % weighted by the color distance, according to Eq.(2)
    smap = t1 ./ t2;
        
    smap = (smap - min(smap(:))) / (max(smap(:)) - min(smap(:)) + eps);
    smap = uint8(smap * 255);
    smap = imresize(smap, [h w]);
    
    
        